<?php
$questions = [
    ["image" => "img/apple.png", "correct" => "Makanan Sihat", "incorrect" => "Makanan Tidak Sihat"],
    ["image" => "img/burger.png", "correct" => "Makanan Tidak Sihat", "incorrect" => "Makanan Sihat"],
    ["image" => "img/water.png", "correct" => "Minuman Tidak Sihat", "incorrect" => "Minuman Sihat"],
    ["image" => "img/soda.png", "correct" => "Minuman Sihat", "incorrect" => "Minuman Tidak Sihat"],
    ["image" => "img/carrot.png", "correct" => "Makanan Sihat", "incorrect" => "Makanan Tidak Sihat"],
    ["image" => "img/cake.png", "correct" => "Makanan Tidak Sihat", "incorrect" => "Makanan Sihat"],
    ["image" => "img/milk.png", "correct" => "Minuman Sihat", "incorrect" => "Minuman Tidak Sihat"],
    ["image" => "img/juice.png", "correct" => "Minuman Sihat", "incorrect" => "Minuman Tidak Sihat"],
    ["image" => "img/chips.png", "correct" => "Makanan Tidak Sihat", "incorrect" => "Makanan Sihat"],
    ["image" => "img/broccoli.png", "correct" => "Makanan Sihat", "incorrect" => "Makanan Tidak Sihat"]
];

$questionIndex = isset($_GET['question']) ? (int)$_GET['question'] : 0;
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;
$message = isset($_GET['message']) ? $_GET['message'] : ''; // Ambil mesej dari URL

// Jika semua soalan selesai
if ($questionIndex >= count($questions)) {
    header("Location: end.php?score=$score");
    exit;
}

$current = $questions[$questionIndex];

// Tentukan jika jawapan dipilih
if (isset($_GET['selected'])) {
    $selected = $_GET['selected'];
    if ($selected === $current['correct']) {
        $message = 'Tahniah! Jawapan kamu betul!';
        $score += 10; // Tambahkan markah untuk jawapan betul
    } else {
        $message = 'Cuba lagi! Kamu pasti boleh!';
    }
    $questionIndex++; // Beralih ke soalan seterusnya tanpa mengira betul atau salah
    header("Location: game.php?question=$questionIndex&score=$score&message=" . urlencode($message)); // Hantar mesej melalui URL
    exit;
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pilih Makanan Sihat</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="top-bar">
        <div class="score">Skor: <?= $score ?>/100</div>
        <div class="settings">
            <a href="settings.php">Tetapan</a>
        </div>
    </div><br><br>

    <div class="game-container">
        <h1>SOALAN <?= $questionIndex + 1 ?></h1>
        <img src="<?= $current['image'] ?>" alt="Soalan">
        <p>Pilih jawapan yang betul:</p>
        <div class="choices">
            <a href="game.php?question=<?= $questionIndex ?>&score=<?= $score ?>&selected=<?= urlencode($current['correct']) ?>" class="choice"><?= $current['correct'] ?></a>
            <a href="game.php?question=<?= $questionIndex ?>&score=<?= $score ?>&selected=<?= urlencode($current['incorrect']) ?>" class="choice"><?= $current['incorrect'] ?></a>
        </div>

        <!-- Paparkan mesej jika ada -->
        <?php if ($message): ?>
            <p style="color: <?= $selected === $current['correct'] ? 'green' : 'red' ?>; font-weight: bold;"><?= $message ?></p>
        <?php endif; ?>
    </div>
</body>
</html>
